
#include <AT89X51.h>
#include "Timer0.h"

unsigned int cputick0;

short Hour;
short Min;
short Sec;

void InitTimer0()
{
	Hour = 12;
	Min = 0;
	Sec = 0;
	cputick0 = 0;
	TMOD &= 0xfe;	// Set Timer 0 as 
	TMOD |= 0x02;	// 8 bit auto reload timer
	TH0 = 6;		// for .25 ms
  	EA = 1;			// Enable all interupts.
	ET0 = 1;		// Enable Timer 1 interrupt.
	TR0 = 1;
}

void Timer0Int() interrupt 1
{
	cputick0 ++;
	if(cputick0 > 7999)
	{
		cputick0 = 0;
		Sec ++;
		if(Sec > 59)
		{
			Sec = 0;
			Min ++;
			if(Min > 59)
			{
				Min = 0;
				Hour ++;
				if(Hour > 23)
					Hour = 0;
			}
		}
	}
}

void GetTime(struct Time* t)
{
	t->Hour = Hour;
	t->Min = Min;
	t->Sec = Sec;
}

void SetHour(short _Hour)
{
	Hour = _Hour;
}

void SetMinute(short _Min)
{
	Min = _Min;
}

void SetSecond(short _Sec)
{
	Sec = _Sec;
}

